CircleShader = {
  vertexShader = [[
  uniform mat4 modelViewProjection;
  
  attribute vec4 position;
  attribute vec4 color;
  attribute vec2 texCoord;
  
  varying lowp vec4 vColor;
  varying highp vec2 vTexCoord;
  void main()
  {
    vColor = color;
    vTexCoord = texCoord;
    gl_Position = modelViewProjection * position;
  }
]],
fragmentShader = [[
precision highp float;

uniform lowp sampler2D texture;
uniform lowp float circleSize;

varying lowp vec4 vColor;
varying highp vec2 vTexCoord;

void main()
{
highp vec4 col;
lowp float dis = distance(vTexCoord,vec2(0.5,0.5)); //get the distance from the texCoord to the center

if (dis < circleSize) { //circleSize is the size of the circle.
  //Turning a rectangular texture into a circle won't actually be that hard. All we have to do is remove
    //the pixels that are distant from the center. It's really that simple!
    col = texture2D(texture, vTexCoord); //sample the pixel in texture at the position vTexCoord
  }
else {col = vec4(0,0,0,0);} //remove this pixel
  gl_FragColor = col;
}
]]
}