--# Main
function setup()
  width,height = HEIGHT*0.9,HEIGHT*0.9 -- the initial width and height of the rect
  textures = {
    readImage(asset.builtin.Cargo_Bot.Codea_Icon),
    readImage(asset.builtin.Platformer_Art.Block_Special),
    readImage(asset.builtin.Cargo_Bot.Background_Fade),
    readImage(asset.builtin.Tyrian_Remastered.Boss_D_Destroyed)
  }
  
  circleM = mesh()
  circleM:addRect(WIDTH/2,HEIGHT/2,width,height) -- add a square to the mesh
  circleM.texture = textures[1]
  circleM.shader = shader(CircleShader.vertexShader,CircleShader.fragmentShader)
  circleM.shader.circleSize = 1
  parameter.number("Circle_Size",0,1,0.25)
  parameter.integer("Texture",1,#textures)
end

function draw()
  background(255, 130, 0, 255)
  circleM.texture = textures[Texture] -- update the meshes texture
  circleM.shader.circleSize = Circle_Size -- update the shader's uniform, circleSize
  if circleM.texture.width*circleM.texture.height < 6400 then
    noSmooth()
  else
    smooth()
  end
  circleM:draw()
end

function touched(t)
  if t.state ~= ENDED then
    width,height = width + t.deltaX*2, height + t.deltaY*2
    circleM:setRect(1,WIDTH/2,HEIGHT/2,width,height)
  end
end

