#extension GL_EXT_separate_shader_objects: enable

uniform mat4 modelViewMatrix;
uniform mat4 projectionMatrix;
uniform mat3 normalMatrix;

layout(location = 0) attribute vec3 position;
layout(location = 1) attribute vec3 normal;

varying vec3 vNormal;

void main() {
    vec3 transformedNormal = normalMatrix * normal; 
    vec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );
    gl_Position = projectionMatrix * mvPosition;
    vNormal = normalize( transformedNormal );       
}
