function setup()
    ----------------------------------------------------------------------------------------------
    -- Single line UITextField
    
    -- Create and configure the UITextField
    local textField = UITextField("") -- initial text
    textField._v.placeholder = "I'm a UITextField. Edit me! (This is placeholder text)"
    textField._v.font = UIFont("SourceCodePro-Medium", 16)
    -- textField._v.text -- Access current text with this value
    
    -- Callback when text changes are confirmed (user presses enter)
    textField.onEdit = function(text)
        print("Text field was edited!", text)
    end
    
    -- Add the UITextField to the root UIView
    UIView.root:addChild(textField)
    
    -- Create layout constraints used to position the UITextField.
    -- The constraints below are primarily examples to demonstrate what you can do with them.
    UIView.root:addConstraint(textField.centerX:eq(UIView.root.centerX))
    UIView.root:addConstraint(textField.width:eq(UIView.root.width * 0.8))
    UIView.root:addConstraint(textField.top:eq(UIView.root.top + 50))
    UIView.root:addConstraint(textField.height:eq(40))
    
    ----------------------------------------------------------------------------------------------
    -- Multi line UITextView
    
    -- Generate the text to display
    local displayText = "I'm an editable text view!\n\nHere is a list of all available fonts:\n"
    for i,fontName in ipairs(UIFonts) do
        displayText = displayText .. " - " .. fontName .. "\n"
    end
    
    -- Create and configure the UITextView
    local textView = UITextView("Hello! I'm an editable text view.") -- Initial text
    textView._v.text = displayText -- Set the text
    textView._v.font = UIFont("SourceCodePro-Medium", 16)
    textView._v.scrollEnabled = true
    textView._v.editable = true
    textView._v.allowsEditingTextAttributes = false -- Bold, Italic etc.
    textView._v.backgroundColor = objc.UIColor.systemDarkGrayColor -- This doesn't seem to do much but rendering is a little wonky if you don't set it.
    
    -- Callback when the text changes
    textView.onEdit = function(text)
        print("Text was edited!")
    end
    
    -- Add the UITextView to the root UIView
    UIView.root:addChild(textView)
    
    -- Create layout constraints used to position the UITextView.
    -- The constraints below are primarily examples to demonstrate what you can do with them.
    UIView.root:addConstraint(textView.centerX:eq(UIView.root.centerX))
    UIView.root:addConstraint(textView.left:eq(UIView.root.left + 50))
    UIView.root:addConstraint(textView.right:eq(UIView.root.right - 50))
    UIView.root:addConstraint(textView.centerY:eq(UIView.root.centerY))
    UIView.root:addConstraint(textView.height:eq(400))
end

function draw()
    background(40, 40, 60)
end