----------------- DO NOT REMOVE OR MOVE -----------------
-- Ensure Codea doesn't load this file automatically
-- This MUST be at the top of this file!
if WRL and not WRL.loading then return end
--------------- END DO NOT REMOVE OR MOVE ---------------
socket = require("socket")
ltn12 = require("ltn12")

Submission = {}

socket.http.TIMEOUT = 5

local json_state = {
    indent = true,
    keyorder = {
        "name",
        "short_description",
        "description",
        "authors",
        "version",
        "update_notes",
        "category",
        "platform",
        "zip_url",
        "metadata_url",
        "hidden",
        "forum_link"
    }
}

-- Callback format: function(direct_url)
local function upload(filename, filepath, callback, string_data)
    
    -- Use the WRL upload function if available
    -- CO'd as this is an async function and I can't be bothered to deal with broken things
    -- atm...
    --[[
    if WRL.Version and WRL.Version >= 2 then
        WRL.API.upload(filename, filepath, string_data, callback)
        return
    end
    ]]
    
    local len = 0
    local filehandle
    
    if filepath then
        filehandle = io.open(filepath, "rb")
    end
    
    if filehandle then
        len = filehandle:seek("end")
        filehandle:seek("set")
        string_data = filehandle:read("*a")
        filehandle:close()
    end
    
    if string_data then
        len = string.len(string_data)
    end
    
    print("Uploading " .. len .. " bytes...")
    
    local boundary = '--WRUploadsy879iuhjkn89iuwbkyjs'
    local header_b = 'Content-Disposition: form-data; name="file"; filename="' .. filename .. '"\r\nContent-Type: text/plain\r\n'
    
    local s1 = '--' .. boundary .. '\r\n' ..header_b ..'\r\n'
    --[[
    local s2 = (filehandle and ltn12.source.file(filehandle)) or ltn12.source.string(string_data)
    ]]
    local s2 = string_data
    local s3 = '\r\n--' .. boundary ..'--\r\n'
    local source = s1 .. s2 .. s3
    local source_len = tostring(#s1 + len + #s3)
    
    --[[
    local source_len = s1:len() + len + s3:len()
    local source = ltn12.source.cat(
        ltn12.source.string(s1),
        s2,
        ltn12.source.string(s3))
    ]]
    
    local response, code, _ = http.requestSync(
        "https://" .. _BACKEND_HOST_ .. "/api/upload",
        {
            method = "POST",
            headers = {
                ["Content-Length"] = source_len,
                ["Content-Type"] = 'multipart/form-data; boundary=' .. boundary    
            },
            data = source
        }
    )
    
    if response == nil then
        print(code)
        callback(nil)
    elseif code == 200 then
        response = json.decode(response)
        callback("https://" .. _BACKEND_HOST_ .. "/uploads/" .. response.filename)
    else
        print(code, response)
        callback(nil)
    end
    
    -- Disabled until LuaSocket has been updated
    -- https://github.com/lunarmodules/luasocket/pull/334
    --[[
    local response_body = {}
    local _, code, _, err = socket.http.request {
        url = "https://api.bayfiles.com/upload",
        method = "POST",
        headers = {
            ["Content-Length"] = source_len,
            ["Content-Type"] = 'multipart/form-data; boundary=' .. boundary    
        },
        source = source,
        sink = ltn12.sink.table(response_body),
    }
    
    if code == 200 then
        local response = json.decode(table.concat(response_body))
        callback(response.data.file.url.short)
    else
        print(code, table.concat(response_body))
        callback(nil)
    end
    ]]
end

function Submission.submitProject(project_name, metadata, progress_cb, error_cb, complete_cb)

    if WRL.Version and WRL.Version >= 2 then WRL.Trace("info") end
    
    if not hasProject("tmp") then
        createProject("tmp")
    end
    
    if asset.documents[project_name .. ".codea"] == nil then
        error_cb("Unable to find project for upload! " .. project_name)
        complete_cb()
        return
    end
    
    -- Grab the original version
    local original_version = nil
    if project_name == "WebRepo" then
        local file = io.open((asset.documents.WebRepo.webrepo_version).path, "r")
        original_version = file:read("*a")
        file:close()
    end
    
    -- Update webrepo version file
    do  
        local file = io.open((asset.documents .. project_name .. ".codea/webrepo_version").path, "w")
        file:write(metadata.version)
        file:close()
    end
        
    progress_cb("Preparing project...")
    tween(0.3, {}, {}, nil, function() -- Delay so the progress message appears
        
        -- Pack dependencies into the project to load automatically
        -- and remove them from Info.plist
        if WRL.Version and WRL.Version >= 2 then WRL.Trace("info", "IncludeDependencies") end
        Packager.IncludeDependencies(project_name, true)
        
        progress_cb("Compressing project...")
        tween(0.3, {}, {}, nil, function() -- Delay so the progress message appears
            
            -- Split large files
            if WRL.Version and WRL.Version >= 2 then WRL.Trace("info", "split", project_name) end
            splitProject(asset.documents[project_name .. ".codea"])
            
            -- Zip the project
            local uncompressedSize
            Thread.runOnMain(function()
                if WRL.Version and WRL.Version >= 2 then WRL.Trace("info", "compressing", project_name) end
                uncompressedSize = Zip.zip(asset.documents[project_name .. ".codea"], asset.documents .. "tmp.codea/project.zip")
            end)
            
            -- Unsplit
            if WRL.Version and WRL.Version >= 2 then WRL.Trace("info", "unsplit", project_name) end
            unsplitProject(asset.documents[project_name .. ".codea"])
            
            -- Restore the version file so we're not told on restart that
            -- an update is available
            if project_name == "WebRepo" then
                local file = io.open((asset.documents .. project_name .. ".codea/webrepo_version").path, "w")
                file:write(original_version)
                file:close()
            end

            -- Add size to metadata
            metadata.size = uncompressedSize
            
            -- Upload zip
            progress_cb("Uploading project")
            tween(0.3, {}, {}, nil, Thread.callback(function() -- Delay so the message appears
                if WRL.Version and WRL.Version >= 2 then WRL.Trace("info", "upload", project_name .. ".zip") end
                upload(project_name .. ".zip", (asset.documents .. "tmp.codea/project.zip").path, function(zip_url)
                    if zip_url == nil then
                        if WRL.Version and WRL.Version >= 2 then WRL.Trace("info", "upload failed", project_name .. ".zip") end
                        error_cb("Failed to upload project zip")
                        complete_cb()
                        return
                    end
                    
                    -- Remove key during the upload
                    local key = metadata.key
                    metadata.key = nil
                    
                    -- Remove old urls
                    metadata.zip_url = nil
                    metadata.metadata_url = nil
                    
                    -- Upload the metadata too
                    progress_cb("Uploading metadata")
                    tween(0.3, {}, {}, nil, Thread.callback(function() -- Delay so the message appears
                        if WRL.Version and WRL.Version >= 2 then WRL.Trace("info", "upload", project_name .. "_meta.json") end
                        upload(project_name .. "_meta.json", nil, function(metadata_url)
                            if metadata_url == nil then
                                if WRL.Version and WRL.Version >= 2 then WRL.Trace("info", "upload failed", project_name .. "_meta.json") end
                                error_cb("Failed to upload metadata file")
                                complete_cb()
                                return
                            end
                            
                            -- Add urls to metadata
                            metadata.zip_url = zip_url
                            metadata.metadata_url = metadata_url
                            
                            -- Restore the key (if any)
                            metadata.key = key
                            
                            progress_cb("Submitting")
                            if WRL.Version and WRL.Version >= 2 then WRL.Trace("info", "submit", project_name) end
                            http.request("https://" .. _BACKEND_HOST_ .. "/api/submit", function(response, code)
                                if code == 200 then
                                    if WRL.Version and WRL.Version >= 2 then WRL.Trace("info", "submit success!", project_name) end
                                    progress_cb("Success!")
                                    complete_cb()
                                else
                                    if WRL.Version and WRL.Version >= 2 then WRL.Trace("info", "submit failure!", project_name, tostring(code)) end
                                    error_cb("Code '" .. tostring(code) .. "' when sending review request")
                                    complete_cb()
                                end
                            end, function(err)
                                if WRL.Version and WRL.Version >= 2 then WRL.Trace("info", "submit failure!", project_name, err) end
                                error_cb("'" .. err .. "' when sending review request")
                                complete_cb()
                            end, {
                                method = "POST",
                                headers = {
                                    ["Content-Type"] = "application/json"
                                },
                                data = json.encode(metadata, json_state)
                            })
                        end, json.encode(metadata, json_state))
                    end))
                end)
                
                deleteProject("tmp")
            end))
        end)
    end)
end
