----------------- DO NOT REMOVE OR MOVE -----------------
-- Ensure Codea doesn't load this file automatically
-- This MUST be at the top of this file!
if WRL and not WRL.loading then return end
--------------- END DO NOT REMOVE OR MOVE ---------------
Zip = {}
local mime = require('mime')

function Zip.zip(folder, outputAsset)
    
    local ucSize = 0

    local zip = {
        cd = {},
        prefix = "",
        offset = 0
    }

    -- The archive data
    io.open(outputAsset.path, 'w'):close() -- '$ touch outputAsset.path'
    local handle = objc.NSFileHandle:fileHandleForWritingAtPath_(outputAsset.path)

    local zipFile = function(file)
        local zipPath = zip.prefix .. file.name

        -- Generate uncompressed crc
        local crc
        local uncompressedSize
        do
            local file = io.open(file.path, "rb")
            while true do
                local data = file:read(4096)
                if data then
                    crc = crc32(data, crc)
                else
                    break
                end
            end
            uncompressedSize = file:seek()
            file:close()
        end
        
        ucSize = ucSize + uncompressedSize
        
        -- Compress file
        local compressedNData
        do
            local buf = objc.NSData:dataWithContentsOfFile_(file.path)
            compressedNData = buf:compressedDataUsingAlgorithm_error_(objc.enum.NSDataCompressionAlgorithm.zlib, nil)
        end

        -- Generate entry header
        local headerNData
        do        
            local header = string.pack('<IBBHHHHIIIHH',
                0x04034b50, -- signature
                19, 20, -- version to extract
                0, -- general purpose flags
                8, -- compression
                0, 0, -- mod time & date
                crc, -- uncompressed crc
                compressedNData.length, -- compressed size
                uncompressedSize, -- uncompressed size
                #zipPath, -- filename length
                0 -- extra field length
            ) .. zipPath -- filename

            local b64header = mime.b64(header)
            headerNData = objc.NSData:dataWithContentsOfFile_(asset.Info.path)
            headerNData:initWithBase64EncodedString_options_(b64header, 0)
        end

        handle:writeData_error_(headerNData, nil)
        handle:writeData_error_(compressedNData, nil)

        -- Add new CD entry
        do        
            local cdh = string.pack('<IBBBBHHHHIIIHHHHHII',
                0x02014b50,
                19, 20,
                19, 20,
                0,
                8,
                0, 0,
                crc,
                compressedNData.length,
                uncompressedSize,
                #zipPath,
                0,
                0,
                0,
                0x0000,
                0,
                zip.offset
            ) .. zipPath

            local b64cdh = mime.b64(cdh)
            cdhNData = objc.NSData:dataWithContentsOfFile_(asset.Info.path)
            cdhNData:initWithBase64EncodedString_options_(b64cdh, 0)
            table.insert(zip.cd, cdhNData)
        end

        -- Update offset
        zip.offset = zip.offset + headerNData.length + compressedNData.length
    end

    local zipFolder
    zipFolder = function(folder)

        local oldPrefix = zip.prefix
        zip.prefix = zip.prefix .. folder.name .. "/"

        for _,e in ipairs(folder.all) do
            if e.type == "folder" or e.type == "project" or e.type == "shader" then
                zipFolder(e)
            else
                zipFile(e)
            end
        end

        zip.prefix = oldPrefix
    end

    -- Add (and compress) all files to the zip archive.
    zipFolder(folder)

    -- Write central directory entries
    local cdStart = zip.offset
    for _,cdh in ipairs(zip.cd) do
        handle:writeData_error_(cdh, nil)
        zip.offset = zip.offset + cdh.length
    end
    local cdSize = zip.offset - cdStart

    -- Write EOCD
    do        
        local eocd = string.pack('<IHHHHIIH',
            0x06054b50,
            0,
            0,
            #zip.cd,
            #zip.cd,
            cdSize,
            cdStart,
            0
        )

        local b64eocd = mime.b64(eocd)
        eocdNData = objc.NSData:dataWithContentsOfFile_(asset.Info.path)
        eocdNData:initWithBase64EncodedString_options_(b64eocd, 0)
        handle:writeData_error_(eocdNData, nil)
        zip.offset = zip.offset + #eocd
    end

    handle:closeAndReturnError_(nil)
    
    return ucSize, zip.offset
end

function Zip.unzip(zipAsset, extractDirAsset)
    local extractPath = extractDirAsset.path
    
    local fhandle = io.open(zipAsset.path, "rb")
    local cd = {}
    
    -- Read EOCD
    fhandle:seek("end", -22)
    local sig, _, _, numFiles, _, cdSize, cdStart, _ = string.unpack('<IHHHHIIH', fhandle:read(22))
    if sig ~= 0x06054b50 then
        error("Failed to open archive!")
    end
    
    -- Read CD
    fhandle:seek("set", cdStart)
    for i = 1, numFiles do
        local stream = fhandle:read(46)
        local sig, _, _, _, method, _, _, crc, csize, size, nameLen, extraLen, _, _, _, _, offset = string.unpack('<IHHHHHHIIIHHHHHII', stream)
        local name = fhandle:read(nameLen)
        fhandle:read(extraLen)
        cd[name] = {
            compression = method,
            crc = crc,
            size_compressed = csize,
            size_uncompressed = size,
            offset = offset
        }
    end
    
    for k,entry in pairs(cd) do
        
        -- Seek to file entry
        fhandle:seek("set", entry.offset)
        
        -- Read header
        local sig, _, _, _, method, _, _, crc, csize, size, nameLen, extraLen = string.unpack('<IBBHHHHIIIHH', fhandle:read(30))
        fhandle:seek("cur", nameLen + extraLen)
        
        if crc ~= entry.crc then
            error("local crc doesn't match central directory crc! " .. k)
        end
        
        -- Read compressed data
        local data = fhandle:read(csize)
        if data == nil then
            error("Failed to read file data! " .. k)
        end
    
        --
        if method == 8 then
            -- Decompress
            local mime = require('mime')
            local b64data = mime.b64(data)
            local buf = objc.NSData:dataWithContentsOfFile_(asset.Info.path)
            buf:initWithBase64EncodedString_options_(b64data, 0)
            local nbuf = buf:decompressedDataUsingAlgorithm_error_(objc.enum.NSDataCompressionAlgorithm.zlib, nil)
            
            -- Write extracted file to disk
            local dir = (extractPath.."/"..k):match("(.*)/.-$")
            if not objc.NSFileManager.defaultManager:fileExistsAtPath_isDirectory_(dir, true) then
                objc.NSFileManager.defaultManager:createDirectoryAtPath_withIntermediateDirectories_attributes_error_(dir, true, nil, nil)
            end
            nbuf:writeToFile_atomically_(extractPath.."/"..k, false)
        elseif method == 0 then
            saveText(extractDirAsset .. k, data)
        else
            error("Unsupported compression method! This is a bug, please report it! ("..method..")")
        end
    end
end

-- crc32 from zzlib
--
-- zzlib - zlib decompression in Lua - version using Lua 5.3 bitwise operators

-- Copyright (c) 2016-2020 Francois Galea <fgalea at free.fr>
-- This program is free software. It comes without any warranty, to
-- the extent permitted by applicable law. You can redistribute it
-- and/or modify it under the terms of the Do What The Fuck You Want
-- To Public License, Version 2, as published by Sam Hocevar. See
-- the COPYING file or http://www.wtfpl.net/ for more details.
local crc32_table
function crc32(s,crc)
    if not crc32_table then
        crc32_table = {}
        for i=0,255 do
            local r=i
            for j=1,8 do
                r = (r >> 1) ~ (0xedb88320 & ~((r & 1) - 1))
            end
            crc32_table[i] = r
        end
    end
    crc = (crc or 0) ~ 0xffffffff
    for i=1,#s do
        local c = s:byte(i)
        crc = crc32_table[c ~ (crc & 0xff)] ~ (crc >> 8)
    end
    crc = (crc or 0) ~ 0xffffffff
    if crc<0 then
        -- in Lua < 5.2, sign extension was performed
        crc = crc + 4294967296
    end
    return crc
end