
-- cloth example

viewer.mode=FULLSCREEN

function setup()
    x1=20
    y1=30
    local tTab={} 
    local xs=1/(x1-1)
    local ys=1/(y1-1)
    for x=0,x1-2 do
        for y=0,y1-2 do
            table.insert(tTab,vec2(x*xs,y*ys))
            table.insert(tTab,vec2(x*xs+xs,y*ys))
            table.insert(tTab,vec2(x*xs+xs,y*ys+ys))            
            table.insert(tTab,vec2(x*xs,y*ys))
            table.insert(tTab,vec2(x*xs,y*ys+ys))
            table.insert(tTab,vec2(x*xs+xs,y*ys+ys))
        end
    end
    local size=30
    dx,dy=0,0
    tab={}
    for x=1,x1 do
        tab[x]={}
        for y=y1,1,-1 do
            local r=physics.body(CIRCLE,0)
            r.x=100+x*size
            r.y=y*size
            r.gravityScale=.5
            if x==1 and y==y1 then
                r.type=STATIC
            end 
            if y==y1 then 
                r.type=STATIC
            end
            tab[x][y]=r
            r=nil
        end
    end
    jVert={}
    for x=1,x1 do
        for y=2,y1 do
            local j=physics.joint(ROPE,tab[x][y-1],tab[x][y],
                tab[x][y-1].position,tab[x][y].position,size)
            table.insert(jVert,j)
            j=nil
        end
    end
    jHorz={}
    for x=2,x1 do
        for y=1,y1 do
            local j=physics.joint(ROPE,tab[x-1][y],tab[x][y],
                tab[x-1][y].position,tab[x][y].position,size)
            table.insert(jHorz,j)
            j=nil
        end
    end  
    m=mesh()
    m.texCoords=tTab
    m.texture="Cargo Bot:Startup Screen"   
    m.vertices=tTab
    buf=m:buffer("position")
end

function draw()
    background(192, 224, 225, 255)
    
    if CurrentOrientation~=PORTRAIT and CurrentOrientation~=PORTRAIT_UPSIDE_DOWN then
        fill(255,0,0)
        text("Rotate the ipad to Portrait mode.",WIDTH/2,HEIGHT/2)
        return
    end

    fill(255)
    stroke(0, 161, 255, 255)
    strokeWidth(2)
    local n=1
    for x=1,x1-1 do
        for y=1,y1-1 do
            buf[n]=vec2(tab[x][y].x,tab[x][y].y)
            buf[n+1]=vec2(tab[x+1][y].x,tab[x+1][y].y)
            buf[n+2]=vec2(tab[x+1][y+1].x,tab[x+1][y+1].y)                              
            buf[n+3]=vec2(tab[x][y].x,tab[x][y].y)
            buf[n+4]=vec2(tab[x][y+1].x,tab[x][y+1].y)
            buf[n+5]=vec2(tab[x+1][y+1].x,tab[x+1][y+1].y) 
            n=n+6           
        end
    end  
    m:draw()
    pushStyle()
    stroke(255,0,0)
    fill(255,0,0)
    ellipse(tab[1][y1].x,tab[1][y1].y,10)
    text("Cloth example",WIDTH/2,HEIGHT-50)
    text("Slide your finger anywhere to move the red dot",WIDTH/2,HEIGHT-80)
    text("Frame rate  "..1/DeltaTime//1,WIDTH/2,HEIGHT-110)
    popStyle()
end

function touched(t)
    if t.state==MOVING then
        for z=1,x1-1 do
            tab[z][y1].type=DYNAMIC
        end
        dx=dx+t.deltaX*50
        dy=dy+t.deltaY*50
        tab[1][y1].linearVelocity=vec2(dx,dy)
    end
    if t.state==ENDED then
        dx,dy=0,0
        tab[1][y1].type=STATIC
    end    
end

