
-- Red Dots

viewer.mode=FULLSCREEN 

function setup()
    -- to clear the scores, uncomment clearProjectData()
    -- run the game, then stop it, then comment it back.
    --clearProjectData()
    if gameState==nil then
        sp=1
        ay=sp
        gameState=infoScreen
    else
        gameState=runGame
        ay=sp
    end
    tslash={}        --    0=no slash, 1=right, -1=left
    tpoint={}        --    0=white, 1=green, 2=red     
    slash=1          --    0=no, 1=right, -1=left    
    bx=200
    by=0
    ax=0
    red=0
    white=0
    green=0
    total=0
    fillTab()
end

function draw()
    background(40, 40, 50)
    if CurrentOrientation~=PORTRAIT and CurrentOrientation~=PORTRAIT_UPSIDE_DOWN then
        fill(255,0,0)
        fontSize(20)
        text("Rotate the ipad to Portrait orientation",WIDTH/2,HEIGHT/2)
        return
    end
    gameState()
end

function touched(t)
    if t.state==BEGAN then
        tx=CurrentTouch.x-250
        ty=CurrentTouch.y-60      
        if gameState==infoScreen then
            if selectSpeed() then
                gameState=runGame
            end
            return
        end
        if gameState==endGame then
            if tx> -230 and tx<-30 and ty>375 and ty<425 then
                setup()
            end
            return
        end
        if green >9 then    -- no more than 10 green dots
            return
        end
        slash = slash * -1
        offset=0
        for xc=0,450,50 do
            for yc=0,900,50 do
                offset = offset + 1
                if tpoint[offset]~=2 then
                    if (ty-yc)^2/25^2+(tx-xc)^2/25^2 <= 1 then
                        tslash[offset]=slash
                        tpoint[offset]=1
                    end
                end
           end
        end
    end
end

function runGame()
    translate(250,60)
    drawDots()
    drawBlueBall()
    drawSlash()
    showScore()
    who() 
end

function endGame()
    translate(250,60)
    drawDots()
    drawSlash()
    showScore()    
    showRestart()
    showHighScore()   
end

function showRestart()
    fontSize(30)
    fill(255)
    rect(-230,375,200,50)
    fill(255,0,0)
    text("NEW GAME",-130,400)
end

function addScore()
    if tpoint[offset]==0 then    -- white circle
        total = total - 1
    end
    if tpoint[offset]==1 then    -- green circle
        total = total + 10
    end
    if tpoint[offset]==2 then    -- red circle
        total = total - 2
    end    
end

function showScore()
    fill(255,0,0)
    fontSize(40)
    text("RedDots",-120,930)
    fontSize(20)
    text(spd,-120,875)      
    fill(0, 255, 251)
    fontSize(40)
    text("SCORE",-120,800)
    text(total,-120,760)
    white=0
    green=0
    red=0
    for x=1,190 do
        if tpoint[x]==0 then
            white = white + 1
        end
        if tpoint[x]==1 then
            green = green + 1
        end  
        if tpoint[x]==2 then
            red = red + 1
        end             
    end
    fill(255)
    str=string.format("White %d",white)
    text(str,-120,700)
    fill(0,255,0)
    str=string.format("Green %d",green)
    text(str,-120,650)
    fill(255,0,0)
    str=string.format("Red %d",red)
    text(str,-120,600)
    if red == 190 and gameState==endGame then
        fill(255,0,0)
        fontSize(30)
        text("Perfect Game",-130,500)
    end
end

function showHighScore()
    pushStyle()
    font("Courier")
    t=total
    for x=1,10 do
        str=string.format("reddots%d",x)
        h=readProjectData(str)
        if h==nil then
            saveProjectData(str,0)
            if t>0 then
                saveProjectData(str,t)
                t=0
            end
        elseif t==tonumber(h) then
                break
        elseif t>tonumber(h) then
                saveProjectData(str,t)
                t=tonumber(h)
        end
    end    
    for x=1,10 do
        str=string.format("reddots%d",x)
        h=readProjectData(str) 
        str=string.format("%2d) %4d",x,h)
        text(str,-130,380-x*35)
    end
    popStyle()
end

function fillTab()
    offset=0
    for x=0,450,50 do
        for y=0,900,50 do
            offset = offset + 1
            tslash[offset]=0
            tpoint[offset]=0 
        end
    end
end

function selectSpeed()
    tx=tx+250  
    ty=ty+60
    if ty<260 or ty>340 then
        return false
    end
    if tx>WIDTH/2-180 and tx<WIDTH/2-20 then
        sp=1
        spd="Slow"
        ay=sp
        return true
    end
    if tx>WIDTH/2+20 and tx<WIDTH/2+180 then
        sp=2
        spd="Fast"
        ay=sp
        return true
    end
    return false
end    

function drawDots()
    offset=0
    for x=0,450,50 do
        for y=0,900,50 do
            offset = offset + 1
            fill(255)
            noStroke()
            if tpoint[offset]==1 then
                fill(0,255,0)
            end
            if tpoint[offset]==2 then
                fill(255,0,0)
            end
            ellipse(x,y,50,50)
        end
    end
end

function changeDirection()
    t=tslash[offset]
    if t~=0 then
        if ay==sp then
            ax=sp*t
            ay=0
            return
        end
        if ay==-sp then
            ax=-sp*t
            ay=0
            return
        end
        if ax==sp then
            ay=sp*t
            ax=0
            return
        end
        if ax==-sp then
            ay=-sp*t
            ax=0
            return
        end
    end
end

function drawBlueBall()
    fill(0,0,255)
    noStroke()
    ellipse(bx,by,30,30)
    bx = bx + ax
    by = by + ay
    if bx<0 or bx >450 or by<0 or by>900 then
        gameState=endGame
        return
    end
    if bx % 50 == 0 and by % 50 == 0 then
        offset=(bx/50*19+(by+50)/50)
        addScore()
        if tslash[offset] ~= 0 then
            tpoint[offset]= 2 
        end
        changeDirection()
        tslash[offset] = tslash[offset] * -1
    end 
end

function who()
    fill(255)
    fontSize(15)
    text("by dave1707",-150,20)
end

function drawSlash()
    offset=0
    stroke(255)
    strokeWidth(8)
    lineCapMode(SQUARE)
    for x=0,450,50 do
        for y=0,900,50 do
            offset = offset + 1
            if tslash[offset]==1 then
                line(x-15,y-15,x+15,y+15)
            end
            if tslash[offset]==-1 then
                line(x-15,y+15,x+15,y-15)
            end
        end
    end   
end

function infoScreen()
    background(40,40,40)
    fontSize(20)
    fill(255)
    w=WIDTH/2
    fill(255,0,0)
    fontSize(40)
    text("Red Dots",WIDTH/2,975)
    fill(255)
    fontSize(20)
    text("The object is to change all the white dots to red.",w,900)
    text("Touch a white dot to turn it green.",w,875)
    text("You can add multiple green dots to get ahead of the blue dot.",w,850)  
    text("You can't have more than 10 green dots at one time.",w,825)
    text("If the blue dot hits a green dot, the green dot will turn red.",w,800)
    text("The blue dot bounces off of the diagonal.",w,775)
    text("The diagonal will change it's direction.",w,750)
    text("Continue tapping a green dot to switch the diagonal direction.",w,725)
    text("Tapping a red dot has no effect on the diagonal.",w,700)
    text("If the blue dot bounces off a red dot diagonal,",w,675)
    text("the red dot diagonal will switch directions.",w,650)
    text("If the blue dot leaves the grid, game over.",w,625)
    text("Scoring is:",w,575)
    text("-1 for crossing a white dot",w,550) 
    text("10 for hitting a green dot",w,525)
    text("-2 for hitting a red dot",w,500)
    text("A perfect game is to get all 190 dots red.",w,400)  
    ellipse(WIDTH/2-100,300,160,80) 
    ellipse(WIDTH/2+100,300,160,80)
    fontSize(40)
    fill(0,255,0)
    text("SLOW",WIDTH/2-100,300)
    text("FAST",WIDTH/2+100,300)
    fontSize(30)
    fill(255,0,0)
    text("Select a speed to start the game.",w,200)
end    

